'Word Search
'There is a bug involving crisscrossing of words due to gridhit() storing no more than one word 
'from the wordlist.  Can we make gridhit a 3 dimensional array gridhit(126, 77, 4)?
option base 1
dim string w$ length 20
dim string word$(117561) length 20
dim string wordlist$(500) length 20
dim string grid$(126, 77) length 1
dim string score1$ length 1, score2$ length 1, score3$ length 1
dim integer h, i, j, r, z, rd, rx, ry, gsx, gsy, endx, endy, num_words, score
dim integer sx, sy, cx, cy, ocx, ocy, cw, ch, csx, csy, cox, coy
dim integer type '1 = user sees a word list, 2 = user sees blank word list initially,
                 'then words appear there when found, 3 = nearly whole screen is grid of letters
dim integer gridstate(126, 77) '0 = green letters, 1 = white letters (found), 2 = LOCKED, white letters
'dim integer gridhit(126, 77) '0 = letter is NOT part of a selected word, otherwise letter IS part of a selected word
dim integer gridhit(126, 77, 4) '0 = letter is NOT part of a selected word
                                'last dimension allows up to four words to crisscross the letter
dim integer letter_count, ghc 'grid hit count
mode 9, 8
font 2 '12x20
color rgb(green)
main()

sub main
  cls
  text 12,  20, "Word Search"
  text 12,  60, "1. 24 x 32 font size"
  text 12,  80, "2. 16 x 24 font size"
  text 12, 100, "3. 12 x 20 font size"
  text 12, 120, "4. 10 x 16 font size"
  text 12, 140, "5.  8 x 12 font size"
  text 12, 160, "6.  6 x  8 font size"
  text 12, 200, "Which size"
  do
    text 12, 220, "" : input size
    if size < 1 or size > 6 then continue do
    exit do
  loop
  text 12, 260, "1. Display a word list"
  text 12, 280, "2. Hide word list initially"
  text 12, 300, "3. No word list"
  text 12, 340, "Which type"
  do
    text 12, 360, "" : input type   
    if type < 1 or type > 3 then continue do
    exit do
  loop
  cls

  if size = 1 and type <> 3 then
    gsx = 20 : gsy = 23 : num_words =  22 : font 5 : fo = 5 '24x32
  elseif size = 2 and type <> 3 then
    gsx = 35 : gsy = 32 : num_words =  30 : font 3 : fo = 3 '16x24
  elseif size = 3 and type <> 3 then
    gsx = 38 : gsy = 35 : num_words =  72 : font 2 : fo = 2 '12x20
  elseif size = 4 and type <> 3 then
    gsx = 49 : gsy = 45 : num_words =  92 : font 4 : fo = 4 '10x16     
  elseif size = 5 and type <> 3 then
    gsx = 62 : gsy = 51 : num_words = 124 : font 1 : fo = 1 '8x12
  elseif size = 6 and type <> 3 then
    gsx = 79 : gsy = 77 : num_words = 285 : font 7 : fo = 7 '6x8  
  elseif size = 1 and type = 3 then
    gsx = 38 : gsy = 23 : num_words =  52 : font 5 : fo = 5
  elseif size = 2 and type = 3 then
    gsx = 53 : gsy = 32 : num_words =  72 : font 3 : fo = 3
  elseif size = 3 and type = 3 then
    gsx = 72 : gsy = 35 : num_words = 120 : font 2 : fo = 2
  elseif size = 4 and type = 3 then
    gsx = 84 : gsy = 45 : num_words = 200 : font 4 : fo = 4
  elseif size = 5 and type = 3 then
    gsx = 92 : gsy = 51 : num_words = 300 : font 1 : fo = 1
  elseif size = 6 and type = 3 then
    gsx = 126 : gsy = 77 : num_words = 500 : font 7 : fo = 7
  endif

  open "Collegiate 20 117561.dat" for input as #1
  for i = 1 to 117561
    line input #1, w$
    word$(i) = w$ 
  next i
  score = 0 : score1$ = "" : score2$ = "" : score3$ = ""
  
  'Initialize arrays
  for i = 1 to 500 'changed from 200 to 500.  Does this fix a bug?
    wordlist$(i) = "" 
  next i
  for i = 1 to 126
    for j = 1 to 77
      grid$(i, j) = ""
      gridstate(i, j) = 0
      'gridhit(i, j) = 0
      gridhit(i, j, 1) = 0
      gridhit(i, j, 2) = 0
      gridhit(i, j, 3) = 0
      gridhit(i, j, 4) = 0
    next j
  next i
  
  for i = 1 to num_words  
    'Select a random word from word array and place it in wordlist array
    do
      r = int(rnd * 117561 + 1)
      if len(word$(r)) < 3 then continue do
      for j = 1 to len(word$(r))
        'chr$(97) = "a", chr$(122) = "z"
        if mid$(lcase$(word$(r)), j, 1) < chr$(97) or mid$(lcase$(word$(r)), j, 1) > chr$(122) then
          continue do
        endif 
      next j
      wordlist$(i) = ucase$(word$(r))
      exit do
    loop
  next i
  
  'Place words from wordlist into grid
  for i = 1 to num_words
    do
      rx = int(rnd * gsx + 1) : ry = int(rnd * gsy + 1) : rd = int(rnd * 8 + 1)
      select case rd '8 directions
        case 1 : endx = rx + len(wordlist$(i)) - 1 : endy = ry + len(wordlist$(i)) - 1
        case 2 : endx = rx + len(wordlist$(i)) - 1 : endy = ry - len(wordlist$(i)) - 1
        case 3 : endx = rx - len(wordlist$(i)) - 1 : endy = ry + len(wordlist$(i)) - 1
        case 4 : endx = rx - len(wordlist$(i)) - 1 : endy = ry - len(wordlist$(i)) - 1
        case 5 : endx = rx + len(wordlist$(i)) - 1 : endy = ry
        case 6 : endx = rx - len(wordlist$(i)) - 1 : endy = ry
        case 7 : endx = rx : endy = ry + len(wordlist$(i)) - 1
        case 8 : endx = rx : endy = ry - len(wordlist$(i)) - 1
      end select
      
      'Check to see if the selected location fits on the grid and is not yet filled with letters
      if endx < 1 or endx > gsx or endy < 1 or endy > gsy then
        continue do
      endif
      'Allow words to crisscross/overlap
      for j = 1 to len(wordlist$(i)) 
        select case rd
          case 1
            if grid$(rx + j - 1, ry + j - 1) <> "" then
              if grid$(rx + j - 1, ry + j - 1) <> mid$(wordlist$(i), j, 1) then 
                continue do
               endif
            endif
          case 2
            if grid$(rx + j - 1, ry - j - 1) <> "" then
              if grid$(rx + j - 1, ry - j - 1) <> mid$(wordlist$(i), j, 1) then
                continue do
              endif
            endif
          case 3
            if grid$(rx - j - 1, ry + j - 1) <> "" then
              if grid$(rx - j - 1, ry + j - 1) <> mid$(wordlist$(i), j, 1) then
                continue do
              endif
            endif
          case 4
            if grid$(rx - j - 1, ry - j - 1) <> "" then
              if grid$(rx - j - 1, ry - j - 1) <> mid$(wordlist$(i), j, 1) then
                continue do
              endif
            endif
          case 5
            if grid$(rx + j - 1, ry) <> "" then
              if grid$(rx + j - 1, ry) <> mid$(wordlist$(i), j, 1) then
                continue do
              endif
            endif
          case 6
            if grid$(rx - j - 1, ry) <> "" then
              if grid$(rx - j - 1, ry) <> mid$(wordlist$(i), j, 1) then
                continue do
              endif
            endif
          case 7
            if grid$(rx, ry + j - 1) <> "" then
              if grid$(rx, ry + j - 1) <> mid$(wordlist$(i), j, 1) then
                continue do
              endif
            endif
          case 8
            if grid$(rx, ry - j - 1) <> "" then
              if grid$(rx, ry - j - 1) <> mid$(wordlist$(i), j, 1) then
                continue do
              endif
            endif
        end select
      next j

      'Copy the letters from the words in the wordlist to the grid
      for j = 1 to len(wordlist$(i))
        select case rd
          case 1 
            grid$(rx + j - 1, ry + j - 1) = mid$(ucase$(wordlist$(i)), j, 1)    
            if gridhit(rx + j - 1, ry + j - 1, 1) = 0 then
              gridhit(rx + j - 1, ry + j - 1, 1) = i    
            elseif gridhit(rx + j - 1, ry + j - 1, 2) = 0 then
              gridhit(rx + j - 1, ry + j - 1, 2) = i
            elseif gridhit(rx + j - 1, ry + j - 1, 3) = 0 then
              gridhit(rx + j - 1, ry + j - 1, 3) = i
            else
              gridhit(rx + j - 1, ry + j - 1, 4) = i
            endif
          case 2
            grid$(rx + j - 1, ry - j - 1) = mid$(ucase$(wordlist$(i)), j, 1)
            if gridhit(rx + j - 1, ry - j - 1, 1) = 0 then
              gridhit(rx + j - 1, ry - j - 1, 1) = i
            elseif gridhit(rx + j - 1, ry - j - 1, 2) = 0 then
              gridhit(rx + j - 1, ry - j - 1, 2) = i
            elseif gridhit(rx + j - 1, ry - j - 1, 3) = 0 then
              gridhit(rx + j - 1, ry - j - 1, 3) = i
            else
              gridhit(rx + j - 1, ry - j - 1, 4) = i
            endif
          case 3 
            grid$(rx - j - 1, ry + j - 1) = mid$(ucase$(wordlist$(i)), j, 1)    
            if gridhit(rx - j - 1, ry + j - 1, 1) = 0 then
              gridhit(rx - j - 1, ry + j - 1, 1) = i
            elseif gridhit(rx - j - 1, ry + j - 1, 2) = 0 then
              gridhit(rx - j - 1, ry + j - 1, 2) = i
            elseif gridhit(rx - j - 1, ry + j - 1, 3) = 0 then
              gridhit(rx - j - 1, ry + j - 1, 3) = i
            else
              gridhit(rx - j - 1, ry + j - 1, 4) = i
            endif
          case 4
            grid$(rx - j - 1, ry - j - 1) = mid$(ucase$(wordlist$(i)), j, 1)
            if gridhit(rx - j - 1, ry - j - 1, 1) = 0 then 
              gridhit(rx - j - 1, ry - j - 1, 1) = i
            elseif gridhit(rx - j - 1, ry - j - 1, 2) = 0 then 
              gridhit(rx - j - 1, ry - j - 1, 2) = i 
            elseif gridhit(rx - j - 1, ry - j - 1, 3) = 0 then 
              gridhit(rx - j - 1, ry - j - 1, 3) = i
            else
              gridhit(rx - j - 1, ry - j - 1, 4) = i
            endif
          case 5 
            grid$(rx + j - 1, ry) = mid$(ucase$(wordlist$(i)), j, 1) 
            if gridhit(rx + j - 1, ry, 1) = 0 then
              gridhit(rx + j - 1, ry, 1) = i
            elseif gridhit(rx + j - 1, ry, 2) = 0 then
              gridhit(rx + j - 1, ry, 2) = i
            elseif gridhit(rx + j - 1, ry, 3) = 0 then
              gridhit(rx + j - 1, ry, 3) = i
            else
              gridhit(rx + j - 1, ry, 4) = i
            endif
          case 6
            grid$(rx - j - 1, ry) = mid$(ucase$(wordlist$(i)), j, 1)
            if gridhit(rx - j - 1, ry, 1) = 0 then
              gridhit(rx - j - 1, ry, 1) = i
            elseif gridhit(rx - j - 1, ry, 2) = 0 then
              gridhit(rx - j - 1, ry, 2) = i  
            elseif gridhit(rx - j - 1, ry, 3) = 0 then
              gridhit(rx - j - 1, ry, 3) = i 
            else
              gridhit(rx - j - 1, ry, 4) = i
            endif
          case 7 
            grid$(rx, ry + j - 1) = mid$(ucase$(wordlist$(i)), j, 1)    
            if gridhit(rx, ry + j - 1, 1) = 0 then
              gridhit(rx, ry + j - 1, 1) = i
            elseif gridhit(rx, ry + j - 1, 2) = 0 then
              gridhit(rx, ry + j - 1, 2) = i
            elseif gridhit(rx, ry + j - 1, 3) = 0 then
              gridhit(rx, ry + j - 1, 3) = i
            else
              gridhit(rx, ry + j - 1, 4) = i
            endif
          case 8
            grid$(rx, ry - j - 1) = mid$(ucase$(wordlist$(i)), j, 1)
            if gridhit(rx, ry - j - 1, 1) = 0 then
              gridhit(rx, ry - j - 1, 1) = i
            elseif gridhit(rx, ry - j - 1, 2) = 0 then
              gridhit(rx, ry - j - 1, 2) = i
            elseif gridhit(rx, ry - j - 1, 3) = 0 then
              gridhit(rx, ry - j - 1, 3) = i
            else
              gridhit(rx, ry - j - 1, 4) = i
            endif
        end select
      next j 
      exit do
    loop
  next i    

  'Fill the empty grid locations with random letters      
  for i = 1 to gsx
    for j = 1 to gsy
      if grid$(i, j) = "" then 
        r = int(rnd * 26 + 1)
        grid$(i, j) = chr$(64 + r) 'chr$(65) = "A", chr$(90) = "Z"
      endif
    next j
  next i

  'Display grid
  for i = 1 to gsx
    for j = 1 to gsy  
      select case size
        case 1
          cox = 26 : coy = 33: sx = 1 : sy = 5
          text cox * (i - 1) + sx, coy * (j - 1) + sy, grid$(i, j),, 5,, rgb(green), rgb(black) 
        case 2
          cox = 19 : coy = 24 : sx = 1 : sy = 1
          text cox * (i - 1) + sx, coy * (j - 1) + sy, grid$(i, j),, 3,, rgb(green), rgb(black) 
        case 3
          cox = 14 : coy = 22 : sx = 2 : sy = 1
          text cox * (i - 1) + sx, coy * (j - 1) + sy, grid$(i, j),, 2,, rgb(green), rgb(black) 
        case 4
          cox = 12 : coy = 17 : sx = 2 : sy = 3
          text cox * (i - 1) + sx, coy * (j - 1) + sy, grid$(i, j),, 4,, rgb(green), rgb(black) 
        case 5
          cox = 11 : coy = 15 : sx = 3 : sy = 6
          text cox * (i - 1) + sx, coy * (j - 1) + sy, grid$(i, j),, 1,, rgb(green), rgb(black) 
        case 6
          cox = 8 : coy = 10 : sx = 1 : sy = 0
          text cox * (i - 1) + sx + 1, coy * (j - 1) + sy + 1, grid$(i, j),, 7,, rgb(green), rgb(black) 
      end select
    next j
  next i

  display_score()

  'Display word list
  select case size
    case 1
      if type <> 3 then
        text 536, 0, "Word List",, 5,, rgb(gray)
      endif
      if type = 1 then
        for i = 1 to num_words
          text 536, 32 * (i +  1), wordlist$(i),, 5,, rgb(yellow)
        next i
      endif
    case 2
      if type <> 3 then
        text 688, 0, "Word List",, 3,, rgb(gray)
      endif
      if type = 1 then
        for i = 1 to num_words
          text 688, 24 * (i +  1), wordlist$(i),, 3,, rgb(yellow)
        next i
      endif
    case 3
      if type <> 3 then
        text 542, 0, "Word List",, 2,, rgb(gray)
      endif
      if type = 1 then
        for i = 1 to num_words
          if i < 37 then
            text 542, 20 * (i +  1), wordlist$(i),, 2,, rgb(yellow)
          else 'i > 36
            text 783, 20 * (i - 35), wordlist$(i),, 2,, rgb(red)
          endif
        next i
      endif
    case 4
      if type <> 3 then
        text 598, 0, "Word List",, 4,, rgb(gray)
      endif
      if type = 1 then
        for i = 1 to num_words
          if i < 47 then
            text 598, 16 * (i +  1), wordlist$(i),, 4,, rgb(yellow)
          else 'i > 46
            text 810, 16 * (i - 45), wordlist$(i),, 4,, rgb(red)
          endif
        next i
      endif
    case 5
      if type <> 3 then  
        text 692, 0, "Word List",, 1,, rgb(gray)
      endif
      if type = 1 then
        for i = 1 to num_words
          if i < 63 then
            text 692, 12 * (i +  1), wordlist$(i),, 1,, rgb(yellow)
          else 'i > 62
            text 858, 12 * (i - 61), wordlist$(i),, 1,, rgb(red)
          endif
        next i
      endif
    case 6
      if type <> 3 then
        text 638, 0, "Word List",, 7,, rgb(gray)
      endif
      if type = 1 then
        for i = 1 to num_words
          if i < 96 then
            text 638, 8 * (i +   1), wordlist$(i),, 7,, rgb(yellow)
          elseif i > 95 and i < 191 then
            text 767, 8 * (i -  94), wordlist$(i),, 7,, rgb(red)
          else 'i > 190
            text 893, 8 * (i - 189), wordlist$(i),, 7,, rgb(cyan)
          endif
        next i
      endif
  end select

  'Display cursor and check for user cursor keys for navigation of grid
  cx = 1 : cy = 1 : ocx = 1 : ocy = 1 : cstate = 0
  select case size
    case 1 : cw = 26 : ch = 33 : csx = sx - 1 : csy = sy - 1 : box csx, csy, cw, ch, 1, rgb(white) 'changed ch from 33 to 34
    case 2 : cw = 19 : ch = 24 : csx = sx - 1 : csy = sy - 1 : box csx, csy, cw, ch, 1, rgb(white)
    case 3 : cw = 14 : ch = 22 : csx = sx - 1 : csy = sy - 1 : box csx, csy, cw, ch, 1, rgb(white)
    case 4 : cw = 12 : ch = 17 : csx = sx - 1 : csy = sy - 1 : box csx, csy, cw, ch, 1, rgb(white)
    case 5 : cw = 11 : ch = 15 : csx = sx - 1 : csy = sy - 1 : box csx, csy, cw, ch, 1, rgb(white)
    case 6 : cw =  8 : ch = 10 : csx = sx - 1 : csy = sy - 1 : box csx, csy, cw, ch, 1, rgb(white)
  end select
  do
    if keydown(0) = 1 then 'Only one key pressed
      if keydown(1) = 128 then 'Cursor Up
        if cy > 1 then 'Will we still be on the grid? 
          pause 115
          ocy = cy : inc cy, -1 : ocx = cx 
          'Erase cursor's old position in grid
          box ((ocx - 1) * cw) + csx, ((ocy - 1) * ch) + csy, cw, ch, 1, rgb(black)
          'Display cursor's new position in grid
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white)
        endif
      elseif keydown(1) = 129 then 'Cursor Down
        if cy < gsy then
          pause 115 
          ocy = cy : inc cy : ocx = cx       
          box ((ocx - 1) * cw) + csx, ((ocy - 1) * ch) + csy, cw, ch, 1, rgb(black)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white)
        endif
      elseif keydown(1) = 130 then 'Cursor Left
        if cx > 1 then
          pause 115
          ocx = cx : inc cx, -1 : ocy = cy     
          box ((ocx - 1) * cw) + csx, ((ocy - 1) * ch) + csy, cw, ch, 1, rgb(black)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white)
        endif
      elseif keydown(1) = 131 then 'Cursor Right      
        if cx < gsx then 
          pause 115 'This pause fixed the bug!
          ocx = cx : inc cx : ocy = cy     
          box ((ocx - 1) * cw) + csx, ((ocy - 1) * ch) + csy, cw, ch, 1, rgb(black)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white)         
        endif
      elseif keydown(1) = 32 then 'Space bar
        pause 115
        if gridstate(cx, cy) = 0 then 'Is letter NOT highlighted?
          gridstate(cx, cy) = 1 'Set highlighting to the ON state
          'Set the letter color to White
          text (cx - 1) * cox + sx, (cy - 1) * coy + sy, grid$(cx, cy),,,, rgb(white)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white) 'Redisplay cursor
          found_word_check()
        elseif gridstate(cx, cy) = 1 then 'Is letter highlighted
          gridstate(cx, cy) = 0 'Set highlighting to the OFF state
          'set the letter color to Green
          text (cx - 1) * cox + sx, (cy - 1) * coy + sy, grid$(cx, cy),,,, rgb(green)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white) 'Redisplay cursor      
        endif        
      endif 
    elseif keydown(0) = 2 then 'Two keys pressed simultaneously
      if (keydown(1) = 128 and keydown(2) = 130) or (keydown(1) = 130 and keydown(2) = 128) then 'Cursor Up and Cursor Left pressed
        if cy > 1 and cx > 1 then 'up and left
          pause 115
          ocx = cx : ocy = cy : inc cx, -1 : inc cy, -1
          box ((ocx - 1) * cw) + csx, ((ocy - 1) * ch) + csy, cw, ch, 1, rgb(black)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white)
        endif
      elseif (keydown(1) = 128 and keydown(2) = 131) or (keydown(1) = 131 and keydown(2) = 128) then 'Cursor Down and Cursor Right
        if cy > 1 and cx < gsx then 'up and right
          pause 115 
          ocx = cx : ocy = cy : inc cx : inc cy, -1
          box ((ocx - 1) * cw) + csx, ((ocy - 1) * ch) + csy, cw, ch, 1, rgb(black)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white)
        endif
      elseif (keydown(1) = 129 and keydown(2) = 130) or (keydown(1) = 130 and keydown(2) = 129) then 'Cursor Down and Cursor Left
        if cy < gsy and cx > 1 then 'down and left
          pause 115
          ocx = cx : ocy = cy : inc cx, -1 : inc cy 
          box ((ocx - 1) * cw) + csx, ((ocy - 1) * ch) + csy, cw, ch, 1, rgb(black)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white)
        endif
      elseif (keydown(1) = 129 and keydown(2) = 131) or (keydown(1) = 131 and keydown(2) = 129) then 'Cursor Down and Cursor Right      
        if cy < gsy and cx < gsx then 'down and right 
          pause 115
          ocx = cx : ocy = cy : inc cx : inc cy
          box ((ocx - 1) * cw) + csx, ((ocy - 1) * ch) + csy, cw, ch, 1, rgb(black)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white)         
        endif
      endif
    endif   
  loop
end sub

sub found_word_check()  
  for z = 1 to 4
    ghc = 0
    if gridhit(cx, cy, z) > 0 then 'Is the letter last highlighted part of a word in the word list?
      h = gridhit(cx, cy, z)
      letter_count = 0
      do
        for i = 1 to gsx
          for j = 1 to gsy
            'if gridhit(i, j, z) = h and gridstate(i, j) <> 0 then 
            if (gridhit(i, j, 1) = h or gridhit(i, j, 2) = h or gridhit(i, j, 3) = h or gridhit(i, j, 4) = h) and gridstate(i, j) <> 0 then
              inc letter_count
              inc ghc
              gridstate(i, j) = 2 'LOCK down this letter so that user cannot unhighlight it
            elseif gridhit(i, j, z) = h and gridstate(i, j) = 0 then
              inc ghc
              exit do
            endif
            if ghc = len(wordlist$(h)) then exit do   
          next j
        next i
        exit do
      loop 
      if letter_count = len(wordlist$(h)) then 'Has user found the word?
        inc score
        if type = 1 then
          'Delete the displayed word in the word list
          select case size
            case 1
              text 536, 32 * (h + 1), "                    ",, 5,, rgb(black) 
            case 2
              text 688, 24 * (h + 1), "                    ",, 3,, rgb(black)        
            case 3
              if h < 37 then
                text 542, 20 * (h + 1), "                    ",, 2,, rgb(black)
              else 'h > 36
                text 783, 20 * (h - 35), "                    ",, 2,, rgb(black)
              endif
            case 4
              if h < 47 then
                text 598, 16 * (h + 1), "                    ",, 4,, rgb(black)
              else 'h > 46
                text 810, 16 * (h - 45), "                    ",, 4,, rgb(black)
              endif
            case 5
              if h < 63 then
                text 692, 12 * (h + 1), "                    ",, 1,, rgb(black)
              else 'h > 62
                text 858, 12 * (h - 61), "                    ",, 1,, rgb(black) 
              endif
            case 6
              if h < 96 then
                text 638, 8 * (h + 1), "                    ",, 7,, rgb(black)
              elseif h > 95 and h < 191 then
                text 767, 8 * (h - 94), "                    ",, 7,, rgb(black) 
              else 'h > 190
                text 893, 8 * (h - 189), "                    ",, 7,, rgb(black)
              endif
          end select
        elseif type = 2 then
          'Display the found word in the word list
          select case size
            case 1
              text 536, 32 * (h + 1), wordlist$(h),, 5,, rgb(yellow) 
            case 2
              text 688, 24 * (h + 1), wordlist$(h),, 3,, rgb(yellow)        
            case 3
              if h < 37 then
                text 542, 20 * (h + 1), wordlist$(h),, 2,, rgb(yellow)
              else 'h > 36
                text 783, 20 * (h - 35), wordlist$(h),, 2,, rgb(red)
              endif
            case 4
              if h < 47 then
                text 598, 16 * (h + 1), wordlist$(h),, 4,, rgb(yellow)
              else 'h > 46
                text 810, 16 * (h - 45), wordlist$(h),, 4,, rgb(red)
              endif
            case 5
              if h < 63 then
                text 692, 12 * (h + 1), wordlist$(h),, 1,, rgb(yellow)
              else 'h > 62
                text 858, 12 * (h - 61), wordlist$(h),, 1,, rgb(red) 
              endif
            case 6
              if h < 96 then
                text 638, 8 * (h + 1), wordlist$(h),, 7,, rgb(yellow)
              elseif h > 95 and h < 191 then
                text 767, 8 * (h - 94), wordlist$(h),, 7,, rgb(red) 
              else 'h > 190
                text 893, 8 * (h - 189), wordlist$(h),, 7,, rgb(cyan)
              endif
          end select

        elseif type = 3 then
          display_score()        
        endif
      endif     
    endif
  next z
end sub

'Display number of words found for game type 3
sub display_score
  if type = 3 then
    if score > 99 then 
      score3$ = left$(str$(score), 1)
      score2$ = mid$(str$(score), 1, 1)
      score1$ = right$(str$(score), 1)
    elseif score > 9 then
      score3$ = ""
      score2$ = left$(str$(score), 1)
      score1$ = right$(str$(score), 1)
    else 'score < 10 
      score3$ = ""
      score2$ = ""
      score1$ = str$(score)
    endif  
    select case size
      case 1
        text 1000,   0, score2$,, 5,, rgb(orange)
        text 1000,  32, score1$,, 5,, rgb(orange)
        text 1000,  96, "o",, 5,, rgb(orange)
        text 1000, 128, "f",, 5,, rgb(orange)
        text 1000, 192, "5",, 5,, rgb(orange) 
        text 1000, 224, "2",, 5,, rgb(orange)
      case 2
        text 1008,   0, score2$,, 3,, rgb(orange)
        text 1008,  24, score1$,, 3,, rgb(orange)
        text 1008,  72, "o",, 3,, rgb(orange)
        text 1008,  96, "f",, 3,, rgb(orange)
        text 1008, 144, "7",, 3,, rgb(orange) 
        text 1008, 168, "2",, 3,, rgb(orange)
      case 3
        text 1010,   0, score3$,, 2,, rgb(orange)
        text 1010,  20, score2$,, 2,, rgb(orange)
        text 1010,  40, score1$,, 2,, rgb(orange)
        text 1010,  80, "o",, 2,, rgb(orange)
        text 1010, 100, "f",, 2,, rgb(orange)
        text 1010, 140, "1",, 2,, rgb(orange)
        text 1010, 160, "2",, 2,, rgb(orange) 
        text 1010, 180, "0",, 2,, rgb(orange)
      case 4
        text 1012,   0, score3$,, 4,, rgb(orange)
        text 1012,  16, score2$,, 4,, rgb(orange)
        text 1012,  32, score1$,, 4,, rgb(orange)
        text 1012,  64, "o",, 4,, rgb(orange)
        text 1012,  80, "f",, 4,, rgb(orange)
        text 1012, 112, "2",, 4,, rgb(orange)
        text 1012, 128, "0",, 4,, rgb(orange) 
        text 1012, 144, "0",, 4,, rgb(orange)
      case 5
        text 1014,   0, score3$,, 1,, rgb(orange)
        text 1014,  12, score2$,, 1,, rgb(orange)
        text 1014,  24, score1$,, 1,, rgb(orange)
        text 1014,  48, "o",, 1,, rgb(orange)
        text 1014,  60, "f",, 1,, rgb(orange)
        text 1014,  84, "3",, 1,, rgb(orange)
        text 1014,  96, "0",, 1,, rgb(orange) 
        text 1014, 108, "0",, 1,, rgb(orange)
      case 6
        text 1016,   0, score3$,, 7,, rgb(orange)
        text 1016,  10, score2$,, 7,, rgb(orange)
        text 1016,  20, score1$,, 7,, rgb(orange)
        text 1016,  40, "o",, 7,, rgb(orange)
        text 1016,  50, "f",, 7,, rgb(orange)
        text 1016,  70, "5",, 7,, rgb(orange)
        text 1016,  80, "0",, 7,, rgb(orange) 
        text 1016,  90, "0",, 7,, rgb(orange)
    end select
  endif
end sub

do : loop


